package com.elitesland.yst.demo.repo;

import com.elitesland.yst.demo.entity.QYstDemoDO;
import com.elitesland.yst.demo.vo.param.YstDemoQueryParamVO;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Predicate;
import com.querydsl.jpa.impl.JPAQueryFactory;
import lombok.RequiredArgsConstructor;
import org.apache.commons.lang3.ObjectUtils;
import org.springframework.stereotype.Component;

/**
 * @author ryan.xu
 * @date 2022-02-15
 */
@Component
@RequiredArgsConstructor
public class YstDemoRepoProc {

    private final JPAQueryFactory jpaQueryFactory;
    private static final QYstDemoDO qYstDemoDO = QYstDemoDO.ystDemoDO;

    /**
     * 条件查询
     *
     * @param param 查询条件
     */
    public Predicate where(YstDemoQueryParamVO param) {
        Predicate predicate = qYstDemoDO.isNotNull().or(qYstDemoDO.isNull());
        if (!ObjectUtils.isEmpty(param.getId())) {
            predicate = ExpressionUtils.and(predicate, qYstDemoDO.id.eq(param.getId()));
        }
        return predicate;
    }

}
