package com.elitesland.yst.demo.service;

import com.elitesland.yst.common.base.PagingVO;
import com.elitesland.yst.demo.vo.param.YstDemoQueryParamVO;
import com.elitesland.yst.demo.vo.resp.YstDemoRespVO;
import com.elitesland.yst.demo.vo.save.YstDemoSaveVO;

import java.util.Optional;

/**
 * @author ryan.xu
 * @date 2022-02-15
 */
public interface YstDemoService {
    /**
     * 保存数据
     *
     * @param saveVO 数据对象
     * @return 数据ID
     */
    Long saveYstDemo(YstDemoSaveVO saveVO);

    /**
     * 更新数据
     *
     * @param saveVO 数据对象
     * @return 数据ID
     */
    void updateYstDemo(YstDemoSaveVO saveVO);

    /**
     * 根据关键字段，返回对应的
     * @param id ID
     * @return 对象
     */
    Optional<YstDemoRespVO> findById(Long id);

    /**
     * 检索
     * @param paramVO 分类查询、分页和排序对象
     * @return 分页结果集
     */
    PagingVO<YstDemoRespVO> search(YstDemoQueryParamVO paramVO);

}
