package com.elitesland.yst.demo.service.impl;

import com.elitesland.yst.common.base.ApiCode;
import com.elitesland.yst.common.base.PagingVO;
import com.elitesland.yst.common.exception.BusinessException;
import com.elitesland.yst.demo.convert.YstDemoConvert;
import com.elitesland.yst.demo.entity.QYstDemoDO;
import com.elitesland.yst.demo.entity.YstDemoDO;
import com.elitesland.yst.demo.repo.YstDemoRepo;
import com.elitesland.yst.demo.repo.YstDemoRepoProc;
import com.elitesland.yst.demo.service.YstDemoService;
import com.elitesland.yst.demo.vo.param.YstDemoQueryParamVO;
import com.elitesland.yst.demo.vo.resp.YstDemoRespVO;
import com.elitesland.yst.demo.vo.save.YstDemoSaveVO;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import lombok.val;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.Optional;
import java.util.stream.Collectors;

/**
 * @author ryan.xu
 * @date 2022-02-15
 */
@Service
@Slf4j
@RequiredArgsConstructor
public class YstDemoServiceImpl implements YstDemoService {

    private static final QYstDemoDO Q_YST_DEMO_DO = QYstDemoDO.ystDemoDO;

    private final YstDemoRepo demoRepo;
    private final YstDemoRepoProc demoRepoProc;

    @Transactional(rollbackFor = Exception.class)
    @Override
    public Long saveYstDemo(YstDemoSaveVO saveVO) {
        YstDemoDO ystDemoDO = YstDemoConvert.INSTANCE.saveToDo(saveVO);
        return demoRepo.save(ystDemoDO).getId();
    }

    @Transactional(rollbackFor = Exception.class)
    @Override
    public void updateYstDemo(YstDemoSaveVO saveVO) {
        Optional<YstDemoDO> optional = demoRepo.findById(saveVO.getId());
        if (optional.isPresent()) {
            YstDemoConvert.INSTANCE.updateDoFromSaveParam(saveVO, optional.get());
            demoRepo.save(optional.get());
        } else {
            throw new BusinessException(ApiCode.FAIL, "修改失败，数据不存在" + saveVO.getId());
        }
    }

    @Override
    public Optional<YstDemoRespVO> findById(Long id) {
        return demoRepo.findById(id).map(YstDemoConvert.INSTANCE::doToVO);
    }

    @Override
    public PagingVO<YstDemoRespVO> search(YstDemoQueryParamVO paramVO) {
        val ret = demoRepo.findAll(demoRepoProc.where(paramVO), paramVO.getPageRequest());
        val vos = ret.getContent().stream().map(YstDemoConvert.INSTANCE::doToVO).collect(Collectors.toList());
        return PagingVO.<YstDemoRespVO>builder()
                .total(ret.getTotalElements())
                .records(vos)
                .build();
    }
}
