package com.elitesland.yst.demo.util.excel.exportExcel;

import com.alibaba.excel.EasyExcel;
import com.alibaba.excel.write.builder.ExcelWriterBuilder;
import com.alibaba.excel.write.style.column.LongestMatchColumnWidthStyleStrategy;

import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.List;

/**
 * <p>
 * excel 导出工具类
 * </p>
 *
 * @author zhao_qiao_gong
 * @since 2020/8/26
 */
public class ExcelWriteUtil {

    /**
     * @param response  响应
     * @param list      出参数据集
     * @param clazz     出参对象类型
     * @param fileName  excel 文件名称
     * @param sheetName excel Sheet页名称
     */
    public static void excelWrite(HttpServletResponse response,
                                  List<?> list,
                                  Class<?> clazz,
                                  String fileName,
                                  String sheetName) throws IOException {
        // 这里注意 有同学反应使用swagger 会导致各种问题，请直接用浏览器或者用postman
        response.setContentType("application/vnd.ms-excel");
        response.setCharacterEncoding("utf-8");
        // 这里URLEncoder.encode可以防止中文乱码 当然和easyexcel没有关系
        fileName = URLEncoder.encode(fileName, String.valueOf(StandardCharsets.UTF_8));
        response.setHeader("Content-disposition", "attachment;filename=" + fileName + ".xlsx");
        ExcelWriterBuilder write = EasyExcel.write(response.getOutputStream(), clazz);
        write.registerConverter(new LocalDateTimeConverter())
                .registerConverter(new LocalDateConverter())
                //根据内容自适应宽度
                .registerWriteHandler(new LongestMatchColumnWidthStyleStrategy())
                //标题提示处理
                .registerWriteHandler(new ExcelTitleHandler(clazz))
                .sheet(sheetName + "1").doWrite(list);
        //       EasyExcel.write(response.getOutputStream(), clazz).registerConverter(new LocalDateTimeConverter()).registerWriteHandler(new LongestMatchColumnWidthStyleStrategy()).sheet(sheetName + "1").doWrite(list);
//        EasyExcel.write(fileName, clazz).registerConverter(new LocalDateTimeConverter()).sheet("模板").doWrite(list);
    }

    public static void excelWriteForSerial(HttpServletResponse response,
                                                 List<?> list,
                                                 Class<?> clazz,
                                                 String fileName,
                                                 String sheetName) throws IOException {
        response.setContentType("application/vnd.ms-excel");
        response.setCharacterEncoding("utf-8");
        // 这里URLEncoder.encode可以防止中文乱码 当然和easyexcel没有关系
        fileName = URLEncoder.encode(fileName, StandardCharsets.UTF_8);
        response.setHeader("Content-disposition", "attachment;filename=" + fileName + ".xlsx");
        ExcelTitleHandler excelTitleHandler = new ExcelTitleHandler(clazz);
        EasyExcel.write(response.getOutputStream(), clazz)
                .registerConverter(new LocalDateTimeConverter())
                .registerWriteHandler(excelTitleHandler)
                .sheet(sheetName + "1")
                .doWrite(list);
    }
}


