package com.elitesland.yst.demo.vo.save;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.Size;
import java.io.Serializable;
import java.math.BigDecimal;

/**
 * @author ryan.xu
 * @date 2022-02-15
 */
@ApiModel(description = "示例的保存参数对象")
@Data
public class YstDemoSaveVO implements Serializable {
    private static final long serialVersionUID = 5866906797416244677L;

    @ApiModelProperty(value = "id")
    private Long id;

    @ApiModelProperty(value = "编码", required = true)
    @NotBlank(message = "编码不能为空")
    @Size(min = 4, max = 10, message = "编码的长度必须在4~10之间")
    private String code;

    @ApiModelProperty(value = "名称", required = true)
    @NotBlank(message = "名称不能为空")
    private String name;

    @ApiModelProperty(value = "是否启用")
    private Boolean enabled;

    @ApiModelProperty(value = "价格")
    private BigDecimal price;

    @ApiModelProperty(value = "图片的唯一编码")
    private String picCode;
}
