/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.yst.demo.config;

import com.elitesland.yst.core.security.jwt.JwtProperties;
import com.github.xiaoymin.knife4j.spring.extension.OpenApiExtensionResolver;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.web.ServerProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import springfox.bean.validators.configuration.BeanValidatorPluginsConfiguration;
import springfox.documentation.builders.ApiInfoBuilder;
import springfox.documentation.builders.ParameterBuilder;
import springfox.documentation.builders.PathSelectors;
import springfox.documentation.builders.RequestHandlerSelectors;
import springfox.documentation.schema.ModelRef;
import springfox.documentation.schema.ModelReference;
import springfox.documentation.service.ApiInfo;
import springfox.documentation.service.Contact;
import springfox.documentation.service.Parameter;
import springfox.documentation.spi.DocumentationType;
import springfox.documentation.spring.web.plugins.Docket;
import springfox.documentation.swagger2.annotations.EnableSwagger2WebMvc;

@Configuration
@ConditionalOnProperty(prefix="knife4j", name={"enable"}, havingValue="true")
@EnableSwagger2WebMvc
@Import(value={BeanValidatorPluginsConfiguration.class})
public class DemoSwaggerConfig {
    private static final Logger logger = LoggerFactory.getLogger(DemoSwaggerConfig.class);
    @Value(value="${swagger.title}")
    private String title;
    @Value(value="${swagger.description}")
    private String description;
    @Value(value="${swagger.url}")
    private String url;
    @Value(value="${swagger.contact.name}")
    private String contactName;
    @Value(value="${swagger.contact.url}")
    private String contactUrl;
    @Value(value="${swagger.contact.email}")
    private String contactEmail;
    @Value(value="${swagger.version}")
    private String version;
    private final JwtProperties jwtProperties;
    private final OpenApiExtensionResolver openApiExtensionResolver;
    private final ServerProperties serverProperties;

    public DemoSwaggerConfig(JwtProperties jwtProperties, OpenApiExtensionResolver openApiExtensionResolver, ServerProperties serverProperties) {
        this.jwtProperties = jwtProperties;
        this.openApiExtensionResolver = openApiExtensionResolver;
        this.serverProperties = serverProperties;
    }

    @Bean
    public Docket createDemoRestApi() {
        String groupName = "CBPL-DMEO Rest\u63a5\u53e3API";
        return new Docket(DocumentationType.SWAGGER_2).groupName(groupName).apiInfo(this.apiInfo(groupName)).select().apis(RequestHandlerSelectors.basePackage((String)"com.elitesland.yst.demo.controller")).paths(PathSelectors.any()).build().globalOperationParameters(List.of(this.parameterHeaderToken(this.jwtProperties.getHeaderAttr(), 0))).extensions(this.openApiExtensionResolver.buildExtensions(groupName));
    }

    private ApiInfo apiInfo(String desc) {
        return new ApiInfoBuilder().title(this.title).description(this.description + "\u3010" + desc + "\u3011").termsOfServiceUrl(this.getServiceUrl()).contact(new Contact(this.contactName, this.contactUrl, this.contactEmail)).version(this.version).build();
    }

    private Parameter parameterHeaderToken(String name, Integer order) {
        return new ParameterBuilder().name(name).parameterType("header").modelRef((ModelReference)new ModelRef("String")).order(order.intValue()).description("\u7528\u6237token").build();
    }

    private String getServiceUrl() {
        if (StringUtils.isNotBlank((CharSequence)this.url)) {
            return this.url;
        }
        int port = Objects.requireNonNullElse(this.serverProperties.getPort(), 8080);
        String contextPath = (String)StringUtils.defaultIfBlank((CharSequence)this.serverProperties.getServlet().getContextPath(), (CharSequence)"");
        return "http://" + this.getIp() + ":" + port + contextPath;
    }

    private String getIp() {
        if (this.serverProperties.getAddress() != null) {
            return this.serverProperties.getAddress().getHostAddress();
        }
        try {
            return InetAddress.getLocalHost().getHostAddress();
        }
        catch (UnknownHostException e) {
            logger.error("\u83b7\u53d6\u670d\u52a1\u5668IP\u5931\u8d25", (Throwable)e);
            return "127.0.0.1";
        }
    }
}

