/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.yst.demo.service.impl;

import com.elitesland.yst.common.base.ApiCode;
import com.elitesland.yst.common.base.PagingVO;
import com.elitesland.yst.common.exception.BusinessException;
import com.elitesland.yst.demo.convert.YstDemoConvert;
import com.elitesland.yst.demo.entity.QYstDemoDO;
import com.elitesland.yst.demo.entity.YstDemoDO;
import com.elitesland.yst.demo.repo.YstDemoRepo;
import com.elitesland.yst.demo.repo.YstDemoRepoProc;
import com.elitesland.yst.demo.service.YstDemoService;
import com.elitesland.yst.demo.vo.param.YstDemoQueryParamVO;
import com.elitesland.yst.demo.vo.resp.YstDemoRespVO;
import com.elitesland.yst.demo.vo.save.YstDemoSaveVO;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class YstDemoServiceImpl
implements YstDemoService {
    private static final Logger logger = LoggerFactory.getLogger(YstDemoServiceImpl.class);
    private static final QYstDemoDO Q_YST_DEMO_DO = QYstDemoDO.ystDemoDO;
    private final YstDemoRepo demoRepo;
    private final YstDemoRepoProc demoRepoProc;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Long saveYstDemo(YstDemoSaveVO saveVO) {
        YstDemoDO ystDemoDO = YstDemoConvert.INSTANCE.saveToDo(saveVO);
        return ((YstDemoDO)this.demoRepo.save(ystDemoDO)).getId();
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void updateYstDemo(YstDemoSaveVO saveVO) {
        Optional optional = this.demoRepo.findById(saveVO.getId());
        if (!optional.isPresent()) {
            throw new BusinessException(ApiCode.FAIL, "\u4fee\u6539\u5931\u8d25\uff0c\u6570\u636e\u4e0d\u5b58\u5728" + saveVO.getId());
        }
        YstDemoConvert.INSTANCE.updateDoFromSaveParam(saveVO, (YstDemoDO)optional.get());
        this.demoRepo.save((YstDemoDO)optional.get());
    }

    @Override
    public Optional<YstDemoRespVO> findById(Long id) {
        return this.demoRepo.findById(id).map(YstDemoConvert.INSTANCE::doToVO);
    }

    @Override
    public PagingVO<YstDemoRespVO> search(YstDemoQueryParamVO paramVO) {
        Page ret = this.demoRepo.findAll(this.demoRepoProc.where(paramVO), (Pageable)paramVO.getPageRequest());
        List vos = ret.getContent().stream().map(YstDemoConvert.INSTANCE::doToVO).collect(Collectors.toList());
        return PagingVO.builder().total(Long.valueOf(ret.getTotalElements())).records(vos).build();
    }

    public YstDemoServiceImpl(YstDemoRepo demoRepo, YstDemoRepoProc demoRepoProc) {
        this.demoRepo = demoRepo;
        this.demoRepoProc = demoRepoProc;
    }
}

