package com.elitesland.cbpl.cloudt.tenant.annotation;

import cn.hutool.core.util.ObjectUtil;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitesland.cbpl.cloudt.tenant.TenantWrapper;
import com.elitesland.cbpl.tool.core.exceptions.ExceptionUtils;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.springframework.stereotype.Component;

import static com.elitesland.cbpl.tool.core.exceptions.TryCatch.tryWrapper;

/**
 * @author eric.hao
 * @since 2023/07/10
 */
@Aspect
@Slf4j
@Component
@RequiredArgsConstructor
public class TenantAsyncAspect {

    private final TenantWrapper tenantWrapper;

    @Around(value = "@annotation(tenantAsync)")
    public Object around(ProceedingJoinPoint point, TenantAsync tenantAsync) {
        var future = tenantWrapper.supplyAsync(() -> tryWrapper(point::proceed));
        // 报错日志
        future.whenComplete((resp, e) -> {
            if (ObjectUtil.isNotNull(e)) {
                log.error(ExceptionUtils.formatException(e));
            }
        });
        // future.get()会阻塞当前线程；直接返回ApiResult.ok()
        return ApiResult.ok();
    }
}
