package com.elitesland.cbpl.cloudt.tenant.annotation;

import java.lang.annotation.*;

/**
 * 解决异步线程中，无法传递 TenantSession.getCurrentTenant();
 * 所以使用 @TenantAsync 的前提是 TenantSession.getCurrentTenant() 可以取到正确租户，
 * 然后调用CompletableFuture，并使用架构封装的线程池参数。
 *
 * @author eric.hao
 * @since 2023/07/10
 */
@Target({ElementType.METHOD})
@Retention(RetentionPolicy.RUNTIME)
@Documented
public @interface TenantAsync {
}
