/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.cbpl.cloudt.tenant;

import com.elitescloud.boot.provider.TenantDataIsolateProvider;
import com.elitescloud.boot.tenant.client.common.TenantClient;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.Supplier;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.task.TaskExecutor;
import org.springframework.stereotype.Component;

@Component
public class TenantWrapper {
    private static final Logger log = LoggerFactory.getLogger(TenantWrapper.class);
    @Resource
    private TaskExecutor taskExecutor;
    @Resource
    private TenantDataIsolateProvider tenantDataIsolateProvider;

    public <T> CompletableFuture<T> supplyAsync(Supplier<T> executor) {
        log.debug("[PHOENIX-CLOUDT] CURRENT TENANT: {}", (Object)TenantClient.getSessionTenant());
        return CompletableFuture.supplyAsync(() -> this.tenantDataIsolateProvider.byTenantDirectly(executor, TenantClient.getSessionTenant()), (Executor)this.taskExecutor);
    }

    public <T> CompletableFuture<Void> runAsync(Supplier<T> executor) {
        log.debug("[PHOENIX-CLOUDT] CURRENT TENANT: {}", (Object)TenantClient.getSessionTenant());
        return CompletableFuture.runAsync(() -> this.tenantDataIsolateProvider.byTenantDirectly(executor, TenantClient.getSessionTenant()), (Executor)this.taskExecutor);
    }
}

