/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.cbpl.cloudt.tenant.annotation;

import cn.hutool.core.util.ObjectUtil;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitesland.cbpl.cloudt.tenant.TenantWrapper;
import com.elitesland.cbpl.cloudt.tenant.annotation.TenantAsync;
import com.elitesland.cbpl.tool.core.exceptions.ExceptionUtils;
import com.elitesland.cbpl.tool.core.exceptions.TryCatch;
import java.util.concurrent.CompletableFuture;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Aspect
@Component
public class TenantAsyncAspect {
    private static final Logger log = LoggerFactory.getLogger(TenantAsyncAspect.class);
    private final TenantWrapper tenantWrapper;

    @Around(value="@annotation(tenantAsync)")
    public Object around(ProceedingJoinPoint point, TenantAsync tenantAsync) {
        CompletableFuture<Object> future = this.tenantWrapper.supplyAsync(() -> TryCatch.tryWrapper(() -> ((ProceedingJoinPoint)point).proceed()));
        future.whenComplete((resp, e) -> {
            if (ObjectUtil.isNotNull((Object)e)) {
                log.error(ExceptionUtils.formatException((Throwable)e));
            }
        });
        return ApiResult.ok();
    }

    public TenantAsyncAspect(TenantWrapper tenantWrapper) {
        this.tenantWrapper = tenantWrapper;
    }
}

