package com.elitesland.cbpl.tool.version.controller;

import com.elitesland.cbpl.tool.version.domain.VersionVO;
import com.elitesland.cbpl.tool.version.service.VersionProvider;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;
import java.util.stream.Collectors;

/**
 * @author eric.hao
 * @since 2024/02/21
 */
@Slf4j
@RestController
@RequiredArgsConstructor
@RequestMapping("/version")
public class VersionDevops {

    private final VersionProvider versionProvider;

    @GetMapping("/dependencies")
    public List<VersionVO> dependencies() {
        return versionProvider.dependencies();
    }

    @GetMapping("/dependencies/format")
    public List<String> dependenciesFormat() {
        return versionProvider.dependencies().stream()
                .map(VersionVO::toString).collect(Collectors.toList());
    }
}
