package com.elitesland.cbpl.tool.version.service;

import cn.hutool.core.collection.ListUtil;
import cn.hutool.core.util.ObjectUtil;
import com.elitesland.cbpl.tool.version.annotation.PhoenixVersion;
import com.elitesland.cbpl.tool.version.domain.VersionVO;
import com.elitesland.cbpl.tool.version.util.ManifestUtils;
import lombok.extern.slf4j.Slf4j;
import org.reflections.Reflections;
import org.springframework.stereotype.Component;

import javax.annotation.Resource;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

/**
 * @author eric.hao
 * @since 2024/02/21
 */
@Slf4j
@Component
public class VersionProvider {

    @Resource
    private Reflections reflections;

    /**
     * 获取所有 Phoenix 工具集的版本
     *
     * @return 版本信息
     */
    public List<VersionVO> dependencies() {
        if (ObjectUtil.isEmpty(reflections)) {
            logger.debug("[PHOENIX-VERSION] Reflections Not Declaring.");
            return ListUtil.empty();
        }
        // 遍历声明的工具版本
        Set<Class<?>> typesAnnotatedWith = reflections.getTypesAnnotatedWith(PhoenixVersion.class);
        return typesAnnotatedWith.stream().map(clazz -> {
            PhoenixVersion version = clazz.getAnnotation(PhoenixVersion.class);
            return ManifestUtils.dependency(clazz, version.description());
        }).collect(Collectors.toList());
    }
}
