package com.elitesland.cbpl.tool.version.util;

import cn.hutool.core.io.ManifestUtil;
import com.elitesland.cbpl.tool.version.domain.VersionVO;

import java.util.jar.Attributes;
import java.util.jar.Manifest;

import static com.elitesland.cbpl.tool.version.constant.ManifestAttr.*;

/**
 * @author eric.hao
 * @since 2024/02/20
 */
public class ManifestUtils {

    /**
     * 根据 class 获取 所在 jar 包版本信息
     *
     * @param clazz 类
     * @param name  项目描述
     * @return 版本信息
     */
    public static VersionVO dependency(Class<?> clazz, String name) {
        Attributes attributes = getMainAttributes(clazz);
        String mavenGroup = attributes.getValue(MAVEN_GROUP);
        String mavenModule = attributes.getValue(MAVEN_MODULE);
        String mavenVersion = attributes.getValue(MAVEN_VERSION);
        String jdkSpec = attributes.getValue(BUILD_JDK_SPEC);
        String buildTime = attributes.getValue(BUILD_TIME);
        return VersionVO.of(name, mavenGroup, mavenModule, mavenVersion, jdkSpec, buildTime);
    }

    /**
     * 根据 class 获取 所在 jar 包文件的 Manifest 属性值
     *
     * @param clazz 类
     * @return Manifest
     */
    public static Attributes getMainAttributes(Class<?> clazz) {
        Manifest manifest = ManifestUtil.getManifest(clazz);
        return manifest.getMainAttributes();
    }
}
