package com.elitesland.cbpl.tool.version.domain;

import lombok.AllArgsConstructor;
import lombok.Data;

/**
 * @author eric.hao
 * @since 2024/02/20
 */
@Data
@AllArgsConstructor(staticName = "of")
public class VersionVO {

    /**
     * 项目描述
     */
    private String name;

    /**
     * 分组
     */
    private String mavenGroup;

    /**
     * 模块
     */
    private String mavenModule;

    /**
     * 版本
     */
    private String mavenVersion;

    /**
     * JDK版本
     */
    private String jdkSpec;

    /**
     * 发布时间
     */
    private String buildTime;

    @Override
    public String toString() {
        return name + "{ " +
                "坐标='" + mavenGroup + ":" + mavenModule + ":" + mavenVersion + '\'' +
                ", JDK版本='" + jdkSpec + '\'' +
                ", 发布时间='" + buildTime + '\'' +
                '}';
    }
}
