package com.elitesland.cbpl.tool.version.annotation;

import com.sun.tools.javac.api.JavacTrees;
import com.sun.tools.javac.code.Flags;
import com.sun.tools.javac.processing.JavacProcessingEnvironment;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.tree.TreeMaker;
import com.sun.tools.javac.tree.TreeTranslator;
import com.sun.tools.javac.util.Context;
import com.sun.tools.javac.util.Names;
import lombok.SneakyThrows;
import lombok.extern.slf4j.Slf4j;

import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import java.util.HashSet;
import java.util.Set;

import static com.elitesland.cbpl.tool.version.constant.GitAttr.*;

/**
 * {@link AbstractProcessor} 就属于 Pluggable Annotation Processing API
 *
 * @author eric.hao
 * @since 2024/02/22
 */
@Slf4j
public class PhoenixVersionProcessor extends AbstractProcessor {

    private TreeMaker treeMaker;
    private JavacTrees trees;
    private Names names;

    /**
     * 初始化处理器
     *
     * @param processingEnv 提供了一系列的实用工具
     */
    @SneakyThrows
    @Override
    public synchronized void init(ProcessingEnvironment processingEnv) {
        super.init(processingEnv);
        Context context = ((JavacProcessingEnvironment) processingEnv).getContext();
        this.trees = JavacTrees.instance(processingEnv);
        this.treeMaker = TreeMaker.instance(context);
        this.names = Names.instance(context);
    }

    @Override
    public Set<String> getSupportedAnnotationTypes() {
        HashSet<String> set = new HashSet<>();
        set.add(PhoenixVersion.class.getName());
        return set;
    }

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        for (TypeElement typeElement : annotations) {
            Set<? extends Element> annotatedElements = roundEnv.getElementsAnnotatedWith(typeElement);
            annotatedElements.forEach(element -> {
                PhoenixVersion anno = element.getAnnotation(PhoenixVersion.class);
                JCTree jcTree = trees.getTree(element);
                jcTree.accept(new TreeTranslator() {
                    @SneakyThrows
                    @Override
                    public void visitClassDef(JCTree.JCClassDecl jcClass) {
                        generateStringField(jcClass, MODULE_CODE, anno.code());
                        generateStringField(jcClass, MODULE_NAME, anno.description());
//                        // GIT提交信息
//                        var properties = new GitProperties<>(PhoenixVersion.class);
//                        generateStringField(jcClass, REPOSITORY_URL, properties.getRemoteUrl());
//                        generateStringField(jcClass, REPOSITORY_BRANCH, properties.getBranch());
//                        generateStringField(jcClass, COMMIT_ID, properties.getCommitId());
//                        generateStringField(jcClass, BUILD_VERSION, properties.getBuildVersion());
                    }
                });
            });
        }
        return true;
    }

    private void generateStringField(JCTree.JCClassDecl jcClassDecl, String fieldName, String fieldValue) {
        // 字段的赋值语句
        JCTree.JCVariableDecl var = treeMaker.VarDef(
                treeMaker.Modifiers(Flags.PUBLIC + Flags.STATIC + Flags.FINAL),
                names.fromString(fieldName),
                treeMaker.Ident(names.fromString("String")),
                treeMaker.Literal(fieldValue)
        );
        jcClassDecl.defs = jcClassDecl.defs.prepend(var);
    }
}
