package com.elitesland.cbpl.tool.version.domain;

import lombok.SneakyThrows;
import lombok.extern.slf4j.Slf4j;

import java.io.InputStream;
import java.util.Properties;

/**
 * @author eric.hao
 * @since 2024/02/23
 */
@Slf4j
public class GitProperties<T> {

    public static final String GIT_PROPERTIES = "git.properties";

    private final Class<T> clazz;

    public GitProperties(Class<T> clazz) {
        this.clazz = clazz;
    }

    public String getBranch() {
        return loadProperties().getProperty("git.branch");
    }

    public String getCommitId() {
        return loadProperties().getProperty("git.commit.id");
    }

    public String getBuildVersion() {
        return loadProperties().getProperty("git.build.version");
    }

    public String getRemoteUrl() {
        return loadProperties().getProperty("git.remote.origin.url");
    }

    @SneakyThrows
    public Properties loadProperties() {
        InputStream inputStream = clazz.getClassLoader().getResourceAsStream(GIT_PROPERTIES);
        Properties properties = new Properties();
        properties.load(inputStream);
        return properties;
    }
}
