package com.elitesland.cbpl.tool.version.service;

import cn.hutool.core.collection.ListUtil;
import cn.hutool.core.util.ObjectUtil;
import com.elitesland.cbpl.tool.version.annotation.PhoenixVersion;
import com.elitesland.cbpl.tool.version.domain.VersionVO;
import com.elitesland.cbpl.tool.version.util.ManifestUtils;
import lombok.SneakyThrows;
import lombok.extern.slf4j.Slf4j;
import org.reflections.Reflections;
import org.springframework.stereotype.Component;

import javax.annotation.Resource;
import java.io.InputStream;
import java.net.URL;
import java.util.*;
import java.util.function.Function;
import java.util.stream.Collectors;

import static com.elitesland.cbpl.tool.version.domain.GitProperties.GIT_PROPERTIES;

/**
 * @author eric.hao
 * @since 2024/02/21
 */
@Slf4j
@Component
public class VersionProvider {

    @Resource
    private Reflections reflections;

    /**
     * 获取所有 Phoenix 工具集的版本
     *
     * @return 版本信息
     */
    public List<VersionVO> dependencies() {
        if (ObjectUtil.isEmpty(reflections)) {
            logger.debug("[PHOENIX-VERSION] Reflections Not Declaring.");
            return ListUtil.empty();
        }
        // 遍历声明的工具版本
        Set<Class<?>> typesAnnotatedWith = reflections.getTypesAnnotatedWith(PhoenixVersion.class);
        return typesAnnotatedWith.stream().map(row ->
                ManifestUtils.dependency(row, loadProperties())
        ).collect(Collectors.toList());
    }

    @SneakyThrows
    private Map<String, Properties> loadProperties() {
        List<Properties> result = new ArrayList<>();
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        Enumeration<URL> enums = classLoader.getResources(GIT_PROPERTIES);
        while (enums.hasMoreElements()) {
            URL tme = enums.nextElement();
            // 通过UrlConnection获取输入流
            InputStream in = tme.openConnection().getInputStream();
            // 将输入流转化为Properties类
            Properties properties = new Properties();
            properties.load(in);
            result.add(properties);
        }
        return result.stream().collect(Collectors.toMap(row ->
                (String) row.get("git.build.module.name"), Function.identity()));
    }
}
