/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.cbpl.tool.version.annotation;

import com.elitesland.cbpl.tool.version.annotation.PhoenixVersion;
import com.sun.tools.javac.api.JavacTrees;
import com.sun.tools.javac.processing.JavacProcessingEnvironment;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.tree.TreeMaker;
import com.sun.tools.javac.tree.TreeTranslator;
import com.sun.tools.javac.util.Context;
import com.sun.tools.javac.util.Names;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PhoenixVersionProcessor
extends AbstractProcessor {
    private static final Logger logger = LoggerFactory.getLogger(PhoenixVersionProcessor.class);
    private TreeMaker treeMaker;
    private JavacTrees trees;
    private Names names;

    @Override
    public synchronized void init(ProcessingEnvironment processingEnv) {
        super.init(processingEnv);
        Context context = ((JavacProcessingEnvironment)processingEnv).getContext();
        this.trees = JavacTrees.instance(processingEnv);
        this.treeMaker = TreeMaker.instance(context);
        this.names = Names.instance(context);
    }

    @Override
    public Set<String> getSupportedAnnotationTypes() {
        HashSet<String> set = new HashSet<String>();
        set.add(PhoenixVersion.class.getName());
        return set;
    }

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        for (TypeElement typeElement : annotations) {
            Set<? extends Element> annotatedElements = roundEnv.getElementsAnnotatedWith(typeElement);
            annotatedElements.forEach(element -> {
                final PhoenixVersion anno = element.getAnnotation(PhoenixVersion.class);
                JCTree jcTree = this.trees.getTree((Element)element);
                jcTree.accept(new TreeTranslator(){

                    @Override
                    public void visitClassDef(JCTree.JCClassDecl jcClass) {
                        PhoenixVersionProcessor.this.generateStringField(jcClass, "MODULE_CODE", anno.code());
                        PhoenixVersionProcessor.this.generateStringField(jcClass, "MODULE_NAME", anno.description());
                    }
                });
            });
        }
        return true;
    }

    private void generateStringField(JCTree.JCClassDecl jcClassDecl, String fieldName, String fieldValue) {
        JCTree.JCVariableDecl var = this.treeMaker.VarDef(this.treeMaker.Modifiers(25L), this.names.fromString(fieldName), this.treeMaker.Ident(this.names.fromString("String")), this.treeMaker.Literal(fieldValue));
        jcClassDecl.defs = jcClassDecl.defs.prepend(var);
    }
}

