/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.cbpl.tool.version.domain;

import java.io.InputStream;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GitProperties<T> {
    private static final Logger logger = LoggerFactory.getLogger(GitProperties.class);
    public static final String GIT_PROPERTIES = "git.properties";
    private final Class<T> clazz;

    public GitProperties(Class<T> clazz) {
        this.clazz = clazz;
    }

    public String getBranch() {
        return this.loadProperties().getProperty("git.branch");
    }

    public String getCommitId() {
        return this.loadProperties().getProperty("git.commit.id");
    }

    public String getBuildVersion() {
        return this.loadProperties().getProperty("git.build.version");
    }

    public String getRemoteUrl() {
        return this.loadProperties().getProperty("git.remote.origin.url");
    }

    public Properties loadProperties() {
        InputStream inputStream = this.clazz.getClassLoader().getResourceAsStream(GIT_PROPERTIES);
        Properties properties = new Properties();
        properties.load(inputStream);
        return properties;
    }
}

