/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.cbpl.tool.version.service;

import cn.hutool.core.collection.ListUtil;
import cn.hutool.core.util.ObjectUtil;
import com.elitesland.cbpl.tool.version.annotation.PhoenixVersion;
import com.elitesland.cbpl.tool.version.domain.VersionVO;
import com.elitesland.cbpl.tool.version.util.ManifestUtils;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.reflections.Reflections;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class VersionProvider {
    private static final Logger logger = LoggerFactory.getLogger(VersionProvider.class);
    @Resource
    private Reflections reflections;

    public List<VersionVO> dependencies() {
        if (ObjectUtil.isEmpty((Object)this.reflections)) {
            logger.debug("[PHOENIX-VERSION] Reflections Not Declaring.");
            return ListUtil.empty();
        }
        Set typesAnnotatedWith = this.reflections.getTypesAnnotatedWith(PhoenixVersion.class);
        return typesAnnotatedWith.stream().map(row -> ManifestUtils.dependency(row, this.loadProperties())).collect(Collectors.toList());
    }

    private Map<String, Properties> loadProperties() {
        ArrayList<Properties> result = new ArrayList<Properties>();
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        Enumeration<URL> enums = classLoader.getResources("git.properties");
        while (enums.hasMoreElements()) {
            URL tme = enums.nextElement();
            InputStream in = tme.openConnection().getInputStream();
            Properties properties = new Properties();
            properties.load(in);
            result.add(properties);
        }
        return result.stream().collect(Collectors.toMap(row -> (String)row.get("git.build.module.name"), Function.identity()));
    }
}

