/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.cbpl.tool.version.util;

import cn.hutool.core.io.ManifestUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.ReflectUtil;
import com.elitesland.cbpl.tool.version.annotation.PhoenixVersion;
import com.elitesland.cbpl.tool.version.domain.VersionVO;
import java.util.Map;
import java.util.Properties;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ManifestUtils {
    private static final Logger logger = LoggerFactory.getLogger(ManifestUtils.class);

    public static VersionVO dependency(Class<?> clazz, Map<String, Properties> gitProperties) {
        Properties properties;
        Attributes attributes = ManifestUtils.getMainAttributes(clazz);
        VersionVO.VersionVOBuilder builder = VersionVO.builder();
        PhoenixVersion version = clazz.getAnnotation(PhoenixVersion.class);
        builder.moduleCode(version.code());
        builder.moduleName(version.description());
        String moduleName = "";
        if (attributes != null && !attributes.isEmpty()) {
            moduleName = attributes.getValue("Maven-Module");
            builder.mavenGroup(attributes.getValue("Maven-Group"));
            builder.mavenModule(moduleName);
            builder.jdkSpec(attributes.getValue("Build-Jdk-Spec"));
            builder.buildTime(attributes.getValue("Build-Time"));
            builder.gradlePluginVersion(attributes.getValue("Gradle-Plugin-Version"));
            builder.supportDepsVersion(attributes.getValue("Support-Dependency-Version"));
            builder.toolDepsVersion(attributes.getValue("Tool-Dependency-Version"));
            builder.phoenixVersion(attributes.getValue("Phoenix-Dependency-Version"));
        }
        if (ObjectUtil.isNotEmpty((Object)(properties = gitProperties.get(moduleName)))) {
            builder.repositoryUrl(properties.getProperty("git.remote.origin.url"));
            builder.repositoryBranch(properties.getProperty("git.branch"));
            builder.commitId(properties.getProperty("git.commit.id"));
            builder.mavenVersion(properties.getProperty("git.build.version"));
        }
        return builder.build();
    }

    public static Attributes getMainAttributes(Class<?> clazz) {
        Manifest manifest = ManifestUtil.getManifest(clazz);
        return ObjectUtil.isEmpty((Object)manifest) ? null : manifest.getMainAttributes();
    }

    private static String gitProperty(Object instance, String fieldName) {
        Object fieldValue = ReflectUtil.getFieldValue((Object)instance, (String)fieldName);
        return ObjectUtil.isEmpty((Object)fieldValue) ? "" : fieldValue.toString();
    }
}

