package com.elitesland.cbpl.common.constant;

import cn.hutool.core.util.ObjectUtil;
import lombok.Getter;

/**
 * @author eric.hao
 * @version 0.1.12-SNAPSHOT
 * @since 2024/06/06
 */
@Getter
public enum QueueSolution {

    /**
     * 消息队列解决方案
     */
    QS_NONE("NONE", "不启用"),
    QS_DISRUPTOR("Disruptor", "内存队列"),
    QS_ROCKET_MQ("RocketMQ", "RocketMQ"),
    QS_KAFKA("Kafka", "Kafka"),
    ;

    private final String code;
    private final String desc;

    QueueSolution(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public static String fromCode(String code) {
        if (ObjectUtil.isNull(code)) return null;
        for (QueueSolution status : QueueSolution.values()) {
            if (status.getCode().compareTo(code) == 0) {
                return status.getDesc();
            }
        }
        return "";
    }
}
