package com.elitesland.cbpl.common.constant;

import cn.hutool.core.util.ObjectUtil;
import lombok.Getter;

/**
 * @author eric.hao
 * @version 0.1.12-SNAPSHOT
 * @since 2024/06/06
 */
@Getter
public enum StorageSolution {

    /**
     * 数据存储解决方案
     */
    DATA_SS_CONSOLE("Console", "本地控制台"),
    DATA_SS_MYSQL("MySQL", "MySQL数据库"),
    DATA_SS_ORACLE("Oracle", "Oracle数据库"),
    DATA_SS_MONGO("MongoDB", "MongoDB数据库"),
    DATA_SS_ES("ES", "Elasticsearch"),
    DATA_SS_REDIS("Redis", "Redis"),
    ;

    private final String code;
    private final String desc;

    StorageSolution(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public static String fromCode(String code) {
        if (ObjectUtil.isNull(code)) return null;
        for (StorageSolution status : StorageSolution.values()) {
            if (status.getCode().compareTo(code) == 0) {
                return status.getDesc();
            }
        }
        return "";
    }
}
