/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.cbpl.tool.core.util;

import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.ReflectUtil;
import cn.hutool.extra.spring.SpringUtil;
import com.elitesland.cbpl.tool.extra.spring.SpringUtils;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.reflections.Configuration;
import org.reflections.Reflections;
import org.reflections.scanners.Scanner;
import org.reflections.scanners.Scanners;
import org.reflections.util.ClasspathHelper;
import org.reflections.util.ConfigurationBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.ReflectionUtils;

public class ReflectUtils {
    private static final Logger logger = LoggerFactory.getLogger(ReflectUtils.class);

    public static Reflections reflections(List<String> basePackages) {
        return ReflectUtils.reflections(basePackages, new Scanner[]{Scanners.TypesAnnotated, Scanners.SubTypes});
    }

    public static Reflections reflections(List<String> basePackages, Scanner ... scanners) {
        ArrayList urls = new ArrayList();
        for (String basePackage : basePackages) {
            urls.addAll(ClasspathHelper.forPackage((String)basePackage, (ClassLoader[])new ClassLoader[0]));
        }
        return new Reflections((Configuration)new ConfigurationBuilder().setUrls(urls).addScanners(scanners));
    }

    public static Set<Class<?>> getTypesAnnotatedWith(Class<? extends Annotation> annotation) {
        Reflections reflections = (Reflections)SpringUtils.getBean(Reflections.class);
        if (ObjectUtil.isEmpty((Object)reflections)) {
            logger.debug("Reflections Not Declaring.");
            return Collections.emptySet();
        }
        return reflections.getTypesAnnotatedWith(annotation);
    }

    public static Object getFieldValue(Object instance, String fieldName) {
        Object fieldValue = instance instanceof Map ? ((Map)instance).get(fieldName) : ReflectUtil.getFieldValue((Object)instance, (String)fieldName);
        return fieldValue;
    }

    public static String getFieldValueOrDefault(Object instance, String fieldName) {
        return ReflectUtils.getFieldValueOrDefault(instance, fieldName, "");
    }

    public static <T> T getFieldValueOrDefault(Object instance, String fieldName, T defaultValue) {
        Object fieldValue = ReflectUtils.getFieldValue(instance, fieldName);
        return (T)(ObjectUtil.isEmpty((Object)fieldValue) ? defaultValue : fieldValue);
    }

    public static Object invokeMethod(String className, String methodName) {
        Object bean = SpringUtils.getClassBean(className);
        return ReflectUtils.invokeMethod(bean, methodName);
    }

    public static Object invokeMethod(Object instance, String methodName) {
        Method method = ReflectionUtils.findMethod(instance.getClass(), (String)methodName);
        return ReflectionUtils.invokeMethod((Method)method, (Object)instance);
    }

    public static <T> List<T> getSubTypesOf(Class<T> superClass) {
        Reflections reflections = (Reflections)SpringUtils.getBean(Reflections.class);
        if (ObjectUtil.isEmpty((Object)reflections)) {
            logger.debug("Reflections Not Declaring.");
            return Collections.emptyList();
        }
        return reflections.getSubTypesOf(superClass).stream().map(SpringUtil::getBean).collect(Collectors.toList());
    }
}

