/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.cbpl.tool.es.repository;

import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.elitesland.cbpl.tool.es.util.ElasticsearchQuery;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import org.apache.commons.lang3.StringUtils;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.elasticsearch.core.ElasticsearchRestTemplate;
import org.springframework.data.elasticsearch.core.RefreshPolicy;
import org.springframework.data.elasticsearch.core.SearchHit;
import org.springframework.data.elasticsearch.core.SearchHits;
import org.springframework.data.elasticsearch.core.mapping.IndexCoordinates;
import org.springframework.data.elasticsearch.core.query.ByQueryResponse;
import org.springframework.data.elasticsearch.core.query.NativeSearchQuery;
import org.springframework.data.elasticsearch.core.query.NativeSearchQueryBuilder;
import org.springframework.data.elasticsearch.core.query.Query;
import org.springframework.stereotype.Component;

@Component
public class ElasticsearchRepository {
    private static final Logger logger = LoggerFactory.getLogger(ElasticsearchRepository.class);
    @Autowired(required=false)
    private ElasticsearchRestTemplate elasticsearchRestTemplate;

    private ElasticsearchRestTemplate getInstance() {
        if (this.elasticsearchRestTemplate == null) {
            throw new IllegalArgumentException("ES\u73af\u5883\u672a\u914d\u7f6e");
        }
        return this.elasticsearchRestTemplate;
    }

    @PostConstruct
    public void init() {
        if (ObjectUtil.isNotNull((Object)this.elasticsearchRestTemplate)) {
            this.getInstance().setRefreshPolicy(RefreshPolicy.IMMEDIATE);
        }
    }

    public boolean existsIndex(String indexName) {
        return this.getInstance().indexOps(IndexCoordinates.of((String[])new String[]{indexName})).exists();
    }

    public boolean createIndex(String indexName) {
        return this.createIndex(indexName, "", "");
    }

    public boolean createIndex(String indexName, String policy, String alias) {
        if (this.existsIndex(indexName)) {
            return true;
        }
        HashMap<String, String> setting = new HashMap<String, String>();
        setting.put("index.lifecycle.name", StrUtil.blankToDefault((CharSequence)policy, (String)""));
        setting.put("index.lifecycle.rollover_alias", StrUtil.blankToDefault((CharSequence)alias, (String)""));
        boolean result = this.getInstance().indexOps(IndexCoordinates.of((String[])new String[]{indexName})).create(setting);
        logger.info("[PHOENIX-ES] CREATE INDEX NAME({}) SUCCESS.", (Object)indexName);
        return result;
    }

    public boolean deleteIndex(String indexName) {
        if (!this.existsIndex(indexName)) {
            logger.warn("[PHOENIX-ES] INDEX NAME({}) NOT EXISTED.", (Object)indexName);
            return true;
        }
        boolean result = this.getInstance().indexOps(IndexCoordinates.of((String[])new String[]{indexName})).delete();
        logger.info("[PHOENIX-ES] DELETE INDEX({}) SUCCESS.", (Object)indexName);
        return result;
    }

    public <T> void insert(T data, String indexName) {
        if (this.createIndex(indexName)) {
            this.getInstance().save(data, IndexCoordinates.of((String[])new String[]{indexName}));
        }
    }

    public <T> void batchInsert(List<T> dataList, String indexName) {
        if (this.createIndex(indexName)) {
            ArrayList indexQueryList = new ArrayList();
            dataList.stream().map(ElasticsearchQuery::indexQueryBuilder).forEach(indexQueryList::add);
            this.getInstance().bulkIndex(indexQueryList, IndexCoordinates.of((String[])new String[]{indexName}));
        }
    }

    public Long delete(String indexName, Class<?> clazz, String bizKey, List<String> bizValue) {
        BoolQueryBuilder boolQueryBuilder = new BoolQueryBuilder();
        boolQueryBuilder.must((QueryBuilder)QueryBuilders.termsQuery((String)bizKey, bizValue));
        NativeSearchQuery query = new NativeSearchQueryBuilder().withQuery((QueryBuilder)boolQueryBuilder).build();
        ByQueryResponse resp = this.getInstance().delete((Query)query, clazz, IndexCoordinates.of((String[])new String[]{indexName}));
        logger.info("[PHOENIX-ES] DELETE index({}) bizKey({}) bizValue({}) SUCCESS.", new Object[]{indexName, bizKey, bizValue});
        return resp.getTotal();
    }

    public void deleteById(String id, String indexName) {
        if (ObjectUtil.isNotNull((Object)id) && StringUtils.isNotBlank((CharSequence)indexName)) {
            this.getInstance().delete(id, IndexCoordinates.of((String[])new String[]{indexName}));
            logger.info("[PHOENIX-ES] DELETE index({}) dataId({}) SUCCESS.", (Object)indexName, (Object)id);
        }
    }

    public <T> List<T> queryList(String indexName, Class<T> clazz, NativeSearchQuery query) {
        SearchHits search = this.getInstance().search((Query)query, clazz, IndexCoordinates.of((String[])new String[]{indexName}));
        if (search.getTotalHits() == 0L) {
            return Collections.emptyList();
        }
        List searchHits = search.getSearchHits();
        return searchHits.stream().map(SearchHit::getContent).collect(Collectors.toList());
    }
}

