/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.cbpl.tool.tenant;

import cn.hutool.core.util.StrUtil;
import cn.hutool.extra.spring.SpringUtil;
import com.elitesland.cbpl.tool.tenant.TenantClientSpi;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;

public class TenantSpiUtil {
    private static final Logger logger = LoggerFactory.getLogger(TenantSpiUtil.class);

    public static String currentTenantCode() {
        try {
            TenantClientSpi tenantClient = (TenantClientSpi)SpringUtil.getBean(TenantClientSpi.class);
            return tenantClient.currentTenantCode();
        }
        catch (NoSuchBeanDefinitionException e) {
            return "";
        }
    }

    public static String tenantPrefix() {
        return TenantSpiUtil.tenantPrefix('_');
    }

    public static String tenantPrefix(char prefix) {
        String tenantCode = TenantSpiUtil.currentTenantCode();
        return StrUtil.isBlank((CharSequence)tenantCode) ? "" : tenantCode + prefix;
    }

    public static void byTenants(Runnable executor) {
        try {
            TenantClientSpi tenantClient = (TenantClientSpi)SpringUtil.getBean(TenantClientSpi.class);
            tenantClient.byTenants(executor);
        }
        catch (NoSuchBeanDefinitionException e) {
            logger.warn("[PHOENIX-TENANT] TenantClientSpi NoSuchBeanDefinition");
            executor.run();
        }
    }

    public static void byTenantDirectly(Runnable executor, String tenantCode) {
        try {
            TenantClientSpi tenantClient = (TenantClientSpi)SpringUtil.getBean(TenantClientSpi.class);
            tenantClient.byTenantDirectly(executor, tenantCode);
        }
        catch (NoSuchBeanDefinitionException e) {
            logger.warn("[PHOENIX-TENANT] TenantClientSpi NoSuchBeanDefinition");
            executor.run();
        }
    }

    public static <E> E byTenantDirectly(Supplier<E> executor, String tenantCode) {
        try {
            TenantClientSpi tenantClient = (TenantClientSpi)SpringUtil.getBean(TenantClientSpi.class);
            return tenantClient.byTenantDirectly(executor, tenantCode);
        }
        catch (NoSuchBeanDefinitionException e) {
            logger.warn("[PHOENIX-TENANT] TenantClientSpi NoSuchBeanDefinition");
            return executor.get();
        }
    }
}

