package com.elitesland.cbpl.tool.crypto;

import org.apache.commons.codec.binary.Base64;

import java.nio.charset.StandardCharsets;

/**
 * @author eric.hao
 * @version 0.1.15-SNAPSHOT
 * @since 2023/04/20
 */
public class BasicAuthUtil {

    /**
     * Basic Auth 加密
     *
     * @param username 用户名
     * @param password 密码
     * @return 加密token
     */
    public static String encryptBasicAuth(String username, String password) {
        String auth = username + ":" + password;
        byte[] encodedAuth = Base64.encodeBase64((auth.getBytes(StandardCharsets.US_ASCII)));
        return "Basic " + new String(encodedAuth);
    }

    /**
     * 接口鉴权
     *
     * @param token    头部token
     * @param username 用户名
     * @param password 密码
     * @return 鉴权结果
     */
    public static boolean checkSignature(String token, String username, String password) {
        return encryptBasicAuth(username, password).equals(token);
    }
}
