package com.elitesland.cbpl.tool.extra.spring;

import cn.hutool.extra.spring.SpringUtil;
import lombok.SneakyThrows;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;

/**
 * @author eric.hao
 * @since 2024/01/11
 */
public class SpringUtils extends SpringUtil {

    /**
     * 类对象，是否在spring容器中存在
     *
     * @param clazz 类
     * @return 是否存在
     */
    public static <T> boolean isPresent(Class<T> clazz) {
        try {
            SpringUtil.getBean(clazz);
        } catch (NoSuchBeanDefinitionException e) {
            return false;
        }
        return true;
    }

    /**
     * 通过类路径获取 Bean
     *
     * @param <T>   对象类型
     * @param clazz 类名
     * @return Bean
     */
    @SneakyThrows
    @SuppressWarnings("unchecked")
    public static <T> T getClassBean(String clazz) {
        return (T) getBean(Class.forName(clazz));
    }
}
