package com.elitesland.cbpl.tool.websocket.config;

import lombok.Data;
import org.springframework.boot.context.properties.ConfigurationProperties;

import static com.elitesland.cbpl.tool.websocket.config.WebSocketProperties.WX_CONFIG_PREFIX;

/**
 * @author eric.hao
 * @since 2022/09/14
 */
@Data
@ConfigurationProperties(prefix = WX_CONFIG_PREFIX)
public class WebSocketProperties {

    public static final String WX_CONFIG_PREFIX = "cbpl.tool.ws";

    /**
     * 是否启用：默认关闭
     */
    private boolean enabled;

    /**
     * WebSocket 接口路径
     */
    private String entry;

    /**
     * WebSocket 许可域名
     */
    private String[] allow;
}
