/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.cbpl.common.constant;

import cn.hutool.core.util.ObjectUtil;

public enum AuthMethod {
    AUTH_METHOD_INHERIT("INHERIT", "Inherit auth from parent"),
    AUTH_METHOD_NO_AUTH("NO_AUTH", "No Auth"),
    AUTH_METHOD_BASIC_AUTH("BASIC_AUTH", "Basic Auth"),
    AUTH_METHOD_TOKEN("TOKEN", "Bearer Token"),
    AUTH_METHOD_JWT("JWT", "JWT Bearer"),
    AUTH_METHOD_OAUTH_V1("OAUTH_1.0", "OAuth 1.0"),
    AUTH_METHOD_OAUTH_V2("OAUTH_2.0", "OAuth 2.0"),
    AUTH_METHOD_AWS("AWS", "AWS Signature"),
    AUTH_METHOD_IP("IP", "IP Whitelist"),
    AUTH_METHOD_WEAVER_E9("WEAVER_E9", "\u6cdb\u5faeE9\u8ba4\u8bc1");

    private final String code;
    private final String desc;

    private AuthMethod(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public static String fromCode(String code) {
        if (ObjectUtil.isNull((Object)code)) {
            return null;
        }
        for (AuthMethod status : AuthMethod.values()) {
            if (status.getCode().compareTo(code) != 0) continue;
            return status.getDesc();
        }
        return "";
    }

    public String getCode() {
        return this.code;
    }

    public String getDesc() {
        return this.desc;
    }
}

