/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.cbpl.tool.redis.util;

import cn.hutool.core.lang.TypeReference;
import cn.hutool.core.util.ArrayUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.extra.spring.SpringUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Component;

@Component
public class RedisUtil {
    private static final Logger logger = LoggerFactory.getLogger(RedisUtil.class);
    private static RedisTemplate<Object, Object> redisTemplate;

    private static RedisTemplate<Object, Object> getInstance() {
        if (redisTemplate == null) {
            redisTemplate = (RedisTemplate)SpringUtil.getBean((TypeReference)new TypeReference<RedisTemplate<Object, Object>>(){});
        }
        return redisTemplate;
    }

    public boolean expire(String key, long time) {
        try {
            if (time > 0L) {
                RedisUtil.getInstance().expire((Object)key, time, TimeUnit.SECONDS);
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            return false;
        }
        return true;
    }

    public boolean expire(String key, long time, TimeUnit timeUnit) {
        try {
            if (time > 0L) {
                RedisUtil.getInstance().expire((Object)key, time, timeUnit);
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            return false;
        }
        return true;
    }

    public long getExpire(Object key) {
        return RedisUtil.getInstance().getExpire(key, TimeUnit.SECONDS);
    }

    public boolean hasKey(String key) {
        try {
            return RedisUtil.getInstance().hasKey((Object)key);
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            return false;
        }
    }

    public void del(String ... keys) {
        if (keys != null && keys.length > 0) {
            if (keys.length == 1) {
                boolean result = RedisUtil.getInstance().delete((Object)keys[0]);
                System.out.println("--------------------------------------------");
                System.out.println(new StringBuilder("\u5220\u9664\u7f13\u5b58\uff1a").append(keys[0]).append("\uff0c\u7ed3\u679c\uff1a").append(result));
                System.out.println("--------------------------------------------");
            } else {
                HashSet keySet = new HashSet();
                for (String key : keys) {
                    keySet.addAll(RedisUtil.getInstance().keys((Object)key));
                }
                long count = RedisUtil.getInstance().delete(keySet);
                System.out.println("--------------------------------------------");
                System.out.println("\u6210\u529f\u5220\u9664\u7f13\u5b58\uff1a" + ((Object)keySet).toString());
                System.out.println("\u7f13\u5b58\u5220\u9664\u6570\u91cf\uff1a" + count + "\u4e2a");
                System.out.println("--------------------------------------------");
            }
        }
    }

    public Object get(String key) {
        return key == null ? null : RedisUtil.getInstance().opsForValue().get((Object)key);
    }

    public String getString(String key) {
        Object value = this.get(key);
        if (ObjectUtil.isNull((Object)value)) {
            return null;
        }
        return ObjectUtil.toString((Object)value);
    }

    public Integer getInt(String key) {
        return Integer.valueOf(this.getString(key));
    }

    public Double getDouble(String key) {
        return Double.valueOf(this.getString(key));
    }

    public Long getLong(String key) {
        return Long.valueOf(this.getString(key));
    }

    public List multiGet(List keys) {
        return RedisUtil.getInstance().opsForValue().multiGet((Collection)keys);
    }

    public boolean set(String key, Object value) {
        try {
            RedisUtil.getInstance().opsForValue().set((Object)key, value);
            return true;
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            return false;
        }
    }

    public boolean set(String key, Object value, long time) {
        try {
            if (time > 0L) {
                RedisUtil.getInstance().opsForValue().set((Object)key, value, time, TimeUnit.SECONDS);
            } else {
                this.set(key, value);
            }
            return true;
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            return false;
        }
    }

    public boolean set(String key, Object value, long time, TimeUnit timeUnit) {
        try {
            if (time > 0L) {
                RedisUtil.getInstance().opsForValue().set((Object)key, value, time, timeUnit);
            } else {
                this.set(key, value);
            }
            return true;
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            return false;
        }
    }

    public Object hget(String key, String item) {
        return RedisUtil.getInstance().opsForHash().get((Object)key, (Object)item);
    }

    public List hmget(String key, Collection items) {
        List dataList = RedisUtil.getInstance().opsForHash().multiGet((Object)key, items);
        if (dataList == null || dataList.isEmpty()) {
            return Collections.emptyList();
        }
        return dataList.stream().filter(Objects::nonNull).collect(Collectors.toList());
    }

    public Map<Object, Object> hmget(String key) {
        return RedisUtil.getInstance().opsForHash().entries((Object)key);
    }

    public boolean hmset(String key, Map<String, ?> map) {
        try {
            RedisUtil.getInstance().opsForHash().putAll((Object)key, map);
            return true;
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            return false;
        }
    }

    public boolean hmset(String key, Map<String, ?> map, long time) {
        try {
            RedisUtil.getInstance().opsForHash().putAll((Object)key, map);
            if (time > 0L) {
                this.expire(key, time);
            }
            return true;
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            return false;
        }
    }

    public boolean hset(String key, String item, Object value) {
        try {
            RedisUtil.getInstance().opsForHash().put((Object)key, (Object)item, value);
            return true;
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            return false;
        }
    }

    public boolean hset(String key, String item, Object value, long time) {
        try {
            RedisUtil.getInstance().opsForHash().put((Object)key, (Object)item, value);
            if (time > 0L) {
                this.expire(key, time);
            }
            return true;
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            return false;
        }
    }

    public void hdel(String key, Object ... item) {
        if (ArrayUtil.isEmpty((Object[])item)) {
            return;
        }
        RedisUtil.getInstance().opsForHash().delete((Object)key, item);
    }

    public void hdel(String key) {
        Set items = RedisUtil.getInstance().opsForHash().keys((Object)key);
        if (items.isEmpty()) {
            return;
        }
        this.hdel(key, items.stream().toArray());
    }

    public boolean hHasKey(String key, String item) {
        return RedisUtil.getInstance().opsForHash().hasKey((Object)key, (Object)item);
    }

    public double hincr(String key, String item, double by) {
        return RedisUtil.getInstance().opsForHash().increment((Object)key, (Object)item, by);
    }

    public double hdecr(String key, String item, double by) {
        return RedisUtil.getInstance().opsForHash().increment((Object)key, (Object)item, -by);
    }

    public Set<Object> sGet(String key) {
        try {
            return RedisUtil.getInstance().opsForSet().members((Object)key);
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public boolean sHasKey(String key, Object value) {
        try {
            return RedisUtil.getInstance().opsForSet().isMember((Object)key, value);
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            return false;
        }
    }

    public long sSet(String key, Object ... values) {
        try {
            return RedisUtil.getInstance().opsForSet().add((Object)key, values);
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            return 0L;
        }
    }

    public long sSetAndTime(String key, long time, Object ... values) {
        try {
            Long count = RedisUtil.getInstance().opsForSet().add((Object)key, values);
            if (time > 0L) {
                this.expire(key, time);
            }
            return count;
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            return 0L;
        }
    }

    public long sGetSetSize(String key) {
        try {
            return RedisUtil.getInstance().opsForSet().size((Object)key);
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            return 0L;
        }
    }

    public long setRemove(String key, Object ... values) {
        try {
            Long count = RedisUtil.getInstance().opsForSet().remove((Object)key, values);
            return count;
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            return 0L;
        }
    }

    public List<Object> lGet(String key, long start, long end) {
        try {
            return RedisUtil.getInstance().opsForList().range((Object)key, start, end);
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public long lGetListSize(String key) {
        try {
            return RedisUtil.getInstance().opsForList().size((Object)key);
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            return 0L;
        }
    }

    public Object lGetIndex(String key, long index) {
        try {
            return RedisUtil.getInstance().opsForList().index((Object)key, index);
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public boolean lSet(String key, Object value) {
        try {
            RedisUtil.getInstance().opsForList().rightPush((Object)key, value);
            return true;
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            return false;
        }
    }

    public boolean lSet(String key, Object value, long time) {
        try {
            RedisUtil.getInstance().opsForList().rightPush((Object)key, value);
            if (time > 0L) {
                this.expire(key, time);
            }
            return true;
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            return false;
        }
    }

    public boolean lSet(String key, List<Object> value) {
        try {
            RedisUtil.getInstance().opsForList().rightPushAll((Object)key, value);
            return true;
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            return false;
        }
    }

    public boolean lSet(String key, List<Object> value, long time) {
        try {
            RedisUtil.getInstance().opsForList().rightPushAll((Object)key, value);
            if (time > 0L) {
                this.expire(key, time);
            }
            return true;
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            return false;
        }
    }

    public boolean lUpdateIndex(String key, long index, Object value) {
        try {
            RedisUtil.getInstance().opsForList().set((Object)key, index, value);
            return true;
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            return false;
        }
    }

    public long lRemove(String key, long count, Object value) {
        try {
            return RedisUtil.getInstance().opsForList().remove((Object)key, count, value);
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            return 0L;
        }
    }

    public void delByKeys(String prefix, Set<Long> ids) {
        HashSet keys = new HashSet();
        for (Long id : ids) {
            keys.addAll(RedisUtil.getInstance().keys((Object)new StringBuffer(prefix).append(id).toString()));
        }
        long count = RedisUtil.getInstance().delete(keys);
        System.out.println("--------------------------------------------");
        System.out.println("\u6210\u529f\u5220\u9664\u7f13\u5b58\uff1a" + ((Object)keys).toString());
        System.out.println("\u7f13\u5b58\u5220\u9664\u6570\u91cf\uff1a" + count + "\u4e2a");
        System.out.println("--------------------------------------------");
    }
}

