package com.elitesland.cbpl.common.constant;

import cn.hutool.core.util.ObjectUtil;
import lombok.Getter;

/**
 * @author eric.hao
 * @version 0.1.12-SNAPSHOT
 * @since 2024/05/16
 */
@Getter
public enum ActiveStatus {

    /**
     * 状态
     */
    ACTIVE(1, "启用"),
    INACTIVE(0, "禁用"),
    ;

    private final Integer code;
    private final String desc;

    ActiveStatus(Integer code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public static String fromCode(Integer code) {
        if (ObjectUtil.isNull(code)) return null;
        for (ActiveStatus status : ActiveStatus.values()) {
            if (status.getCode().compareTo(code) == 0) {
                return status.getDesc();
            }
        }
        return "";
    }
}
