package com.elitesland.cbpl.common.constant;

import cn.hutool.core.util.ObjectUtil;
import lombok.Getter;

/**
 * @author eric.hao
 * @version 0.1.16-SNAPSHOT
 * @since 2024/10/05
 */
@Getter
public enum YesOrNo {

    /**
     * 状态
     */
    YES(1, "是"),
    NO(0, "否"),
    ;

    private final Integer code;
    private final String desc;

    YesOrNo(Integer code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public static String fromCode(Integer code) {
        if (ObjectUtil.isNull(code)) return null;
        for (YesOrNo status : YesOrNo.values()) {
            if (status.getCode().compareTo(code) == 0) {
                return status.getDesc();
            }
        }
        return NO.getDesc();
    }
}
