package com.elitesland.cbpl.tool.aop;

import lombok.extern.slf4j.Slf4j;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.reflect.MethodSignature;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;

/**
 * @author eric.hao
 * @since 2023/08/30
 */
@Slf4j
public class AopAssistant {

    /**
     * 获取方法
     */
    public static Method getMethod(JoinPoint joinPoint) {
        MethodSignature methodSignature = (MethodSignature) joinPoint.getSignature();
        return methodSignature.getMethod();
    }

    /**
     * 获取方法上的注解
     */
    public static <T extends Annotation> T[] getAnnotations(JoinPoint joinPoint, Class<T> annotationType) {
        Method method = AopAssistant.getMethod(joinPoint);
        return method.getAnnotationsByType(annotationType);
    }

    /**
     * 获取方法上的参数名称
     */
    public static String[] getParameterNames(JoinPoint joinPoint) {
        return ((MethodSignature) joinPoint.getSignature()).getParameterNames();
    }

    /**
     * 获取方法上的参数值
     */
    public static Map<String, Object> getParameters(JoinPoint joinPoint) {
        Map<String, Object> params = new HashMap<>();
        String[] parameterNames = AopAssistant.getParameterNames(joinPoint);
        Object[] arguments = joinPoint.getArgs();
        if (parameterNames != null) {
            for (int len = 0; len < parameterNames.length; len++) {
                params.put(parameterNames[len], arguments[len]);
            }
        }
        return params;
    }

    /**
     * 获取指定参数值
     */
    public static Object getParameterValue(JoinPoint joinPoint, String parameterName) {
        Map<String, Object> parameters = getParameters(joinPoint);
        return parameters.get(parameterName);
    }
}
