package com.elitesland.cbpl.tool.websocket.handler;

import cn.hutool.core.collection.CollUtil;
import com.corundumstudio.socketio.AckRequest;
import com.corundumstudio.socketio.SocketIOClient;
import com.corundumstudio.socketio.annotation.OnEvent;
import com.elitesland.cbpl.tool.extra.spring.SpringUtils;
import com.elitesland.cbpl.tool.websocket.constant.WebSocketConstant;
import com.elitesland.cbpl.tool.websocket.notifier.WebSocketNotifier;
import com.elitesland.cbpl.tool.websocket.notifier.domain.ChatPayload;
import lombok.extern.slf4j.Slf4j;

import java.util.List;
import java.util.Map;
import java.util.Set;

/**
 * @author eric.hao
 * @since 2024/12/09
 */
@Slf4j
public class WebSocketDefaultHandler {

    @OnEvent(value = WebSocketConstant.SocketEvent.MESSAGE)
    public void onTextMessage(SocketIOClient session, String data, AckRequest ackRequest) {
        // 目前WebSocket的使用场景仅用于单向发送站内消息，故消息接收处理被忽略。
        logger.info("[PHOENIX-WS] message from websocket client: {}", data);
        if (ackRequest.isAckRequested()) {
            // 返回给客户端，表示接收到了
            ackRequest.sendAckData("success");
        }
    }

    @OnEvent(value = WebSocketConstant.SocketEvent.CHANNEL_SYSTEM)
    public void onChannelSystem(SocketIOClient session, String data, AckRequest ackRequest) {
        String ackData = "success";

        String fromUserId = WebSocketSessionManager.getUserId(session);
        String toUserId = getUrlParams(session, "toUserId");
        logger.info("[PHOENIX-WS] chat message, from-{}, to-{}, message-{}", fromUserId, toUserId, data);

        if (toUserId == null) {
            ackData = "no recipient.";
        } else if (data == null) {
            ackData = "empty message.";
        } else {
            WebSocketNotifier notifier = SpringUtils.getBean(WebSocketNotifier.class);
            ChatPayload payload = ChatPayload.builder().content(data)
                    .from(fromUserId).tos(Set.of(toUserId)).build();
            notifier.notify(payload);
        }

        if (ackRequest.isAckRequested()) {
            // 返回给客户端，表示接收到了
            ackRequest.sendAckData(ackData);
        }
    }

    /**
     * 获取url参数
     */
    private String getUrlParams(SocketIOClient session, String key) {
        Map<String, List<String>> urlParams = session.getHandshakeData().getUrlParams();
        List<String> params = urlParams.get(key);
        if (CollUtil.isNotEmpty(params)) {
            return params.get(0);
        }
        return null;
    }
}
