package com.elitesland.cbpl.tool.websocket.handler.domain;

import com.corundumstudio.socketio.SocketIOClient;
import com.elitesland.cbpl.tool.websocket.handler.WebSocketSessionManager;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.Data;

import java.time.LocalDateTime;
import java.util.UUID;

/**
 * 用户信息
 *
 * @author eric.hao
 * @since 2024/11/19
 */
@Data
public class OnlineUser {

    /**
     * 会话
     */
    @JsonIgnore
    private SocketIOClient session;

    /**
     * 会话ID
     */
    @JsonProperty
    public UUID getSessionId() {
        return session.getSessionId();
    }

    /**
     * 用户ID
     */
    @JsonProperty
    public String getUid() {
        return WebSocketSessionManager.getUserId(session);
    }

    /**
     * 登录账号
     */
    @JsonProperty
    public String getUsername() {
        return WebSocketSessionManager.getUsername(session);
    }

    /**
     * 用户昵称
     */
    @JsonProperty
    public String getNickname() {
        return WebSocketSessionManager.getNickname(session);
    }

    /**
     * 用户昵称
     */
    @JsonProperty
    public String getTenantCode() {
        return WebSocketSessionManager.getTenantCode(session);
    }

    /**
     * 客户端IP
     */
    private String ip;

    /**
     * 登记时间
     */
    private LocalDateTime now;

    public static OnlineUser of(SocketIOClient session, String ip) {
        OnlineUser user = new OnlineUser();
        user.setSession(session);
        user.setIp(ip);
        user.setNow(LocalDateTime.now());
        return user;
    }
}
