package com.elitesland.cbpl.tool.websocket.registrar;

import com.corundumstudio.socketio.SocketIOServer;
import com.elitesland.cbpl.tool.websocket.config.WebSocketProperties;
import com.elitesland.cbpl.tool.websocket.handler.WebSocketDefaultHandler;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.boot.CommandLineRunner;
import org.springframework.core.annotation.Order;

/**
 * @author eric.hao
 * @since 2024/11/18
 */
@Slf4j
@RequiredArgsConstructor
@Order(value = 1)
public class WebSocketInitialize implements CommandLineRunner, DisposableBean {

    private final SocketIOServer server;
    private final WebSocketProperties properties;

    @Override
    public void run(String... args) {
        try {
            server.getNamespace(properties.getNamespace())
                    .addListeners(new WebSocketDefaultHandler());
            server.start();
        } catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    /**
     * 如果用kill -9  这个监听是没用的
     * 有可能会导致你服务kill掉了，但是socket服务没有kill掉
     */
    @Override
    public void destroy() {
        server.stop();
    }
}
