package com.elitesland.cbpl.tool.websocket.registrar;

import com.corundumstudio.socketio.SocketIOServer;
import com.elitesland.cbpl.tool.websocket.handler.WebSocketSessionManager;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;

import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;

/**
 * @author eric.hao
 * @since 2024/12/09
 */
@Slf4j
@RequiredArgsConstructor
public class WebSocketListener {

    /**
     * 服务器socket对象
     */
    private final SocketIOServer socketIoServer;

    /**
     * 启动初始化
     */
    @PostConstruct
    public void init() {
        logger.debug("SocketEventListener initialized");

        // 添加监听，客户端自动连接到 socket 服务端
        socketIoServer.addConnectListener(session -> {
            String userId = WebSocketSessionManager.getUserId(session);
            logger.info("[PHOENIX-WS] websocket connection established: {} of u-{}", session.getSessionId(), userId);
            WebSocketSessionManager.add(session);
        });

        // 添加监听，客户端跟 socket 服务端自动断开
        socketIoServer.addDisconnectListener(client -> {
            String userId = WebSocketSessionManager.getUserId(client);
            logger.info("[PHOENIX-WS] websocket disconnection finished: {} of u-{}", client.getSessionId(), userId);
            WebSocketSessionManager.remove(client);
        });
    }

    /**
     * 容器销毁前，自动调用此方法，关闭 SocketIO 服务端
     **/
    @PreDestroy
    private void destroy() {
        try {
            logger.info("[PHOENIX-WS] websocket server closed.");
            socketIoServer.stop();
        } catch (Exception e) {
            e.printStackTrace();
        }
    }
}
