/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.cbpl.tool.mongo.repository;

import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.elitesland.cbpl.tool.core.exceptions.PhoenixException;
import com.elitesland.cbpl.tool.mongo.domain.MongoDoc;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.mongodb.core.MongoTemplate;

public class MongoStorer {
    private static final Logger logger = LoggerFactory.getLogger(MongoStorer.class);
    private static final String ERR_UNCHECKED = "MongoDB\u7d22\u5f15\u540d\u79f0\u914d\u7f6e\u7f3a\u5931";
    private final MongoTemplate mongoTemplate;

    public <T extends MongoDoc> void save(T doc) {
        if (ObjectUtil.isEmpty(doc) || ObjectUtil.isEmpty(doc.getType())) {
            throw PhoenixException.unchecked(ERR_UNCHECKED);
        }
        this.save(doc, doc.getType().getStoreName());
    }

    public <T extends MongoDoc> void save(T doc, String storeName) {
        if (StrUtil.isBlank((CharSequence)storeName)) {
            throw PhoenixException.unchecked(ERR_UNCHECKED);
        }
        logger.debug("[MONGO] store use {}", (Object)storeName);
        this.mongoTemplate.insert(doc, storeName);
    }

    public MongoStorer(MongoTemplate mongoTemplate) {
        this.mongoTemplate = mongoTemplate;
    }
}

