/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.cbpl.tool.websocket.config;

import com.corundumstudio.socketio.Configuration;
import com.corundumstudio.socketio.SocketConfig;
import com.corundumstudio.socketio.SocketIOServer;
import com.corundumstudio.socketio.annotation.SpringAnnotationScanner;
import com.elitesland.cbpl.tool.websocket.config.WebSocketProperties;
import com.elitesland.cbpl.tool.websocket.notifier.WebSocketNotifier;
import com.elitesland.cbpl.tool.websocket.registrar.WebSocketInitialize;
import com.elitesland.cbpl.tool.websocket.registrar.WebSocketListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.web.socket.config.annotation.EnableWebSocket;

@EnableWebSocket
@org.springframework.context.annotation.Configuration
@EnableConfigurationProperties(value={WebSocketProperties.class})
@ConditionalOnProperty(prefix="cbpl.tool.ws", name={"enabled"}, havingValue="true")
public class WebSocketConfig {
    private static final Logger logger = LoggerFactory.getLogger(WebSocketConfig.class);
    private final WebSocketProperties webSocketProperties;

    @Bean
    public SocketIOServer socketIOServer() {
        SocketConfig socketConfig = new SocketConfig();
        socketConfig.setSoLinger(0);
        socketConfig.setReuseAddress(true);
        Configuration config = new Configuration();
        config.setSocketConfig(socketConfig);
        config.setPort(this.webSocketProperties.getPort().intValue());
        config.setContext(this.webSocketProperties.getContextPath());
        config.setBossThreads(this.webSocketProperties.getBossCount());
        config.setWorkerThreads(this.webSocketProperties.getBossCount());
        config.setAllowCustomRequests(this.webSocketProperties.isAllowCustomRequests());
        config.setUpgradeTimeout(this.webSocketProperties.getUpgradeTimeout());
        config.setPingTimeout(this.webSocketProperties.getPingTimeout());
        config.setPingInterval(this.webSocketProperties.getPingInterval());
        config.setRandomSession(true);
        config.setOrigin("*");
        SocketIOServer server = new SocketIOServer(config);
        server.addNamespace(this.webSocketProperties.getNamespace());
        String url = this.webSocketProperties.getHost() + ":" + this.webSocketProperties.getPort() + this.webSocketProperties.getNamespace();
        logger.info("[PHOENIX-WS] websocket server namespace: {}", (Object)url);
        return server;
    }

    @Bean
    @ConditionalOnMissingBean
    public WebSocketNotifier webSocketPusher(SocketIOServer socketServer) {
        logger.info("[PHOENIX-WS] websocket message pusher");
        return new WebSocketNotifier(socketServer, this.webSocketProperties);
    }

    @Bean
    public SpringAnnotationScanner springAnnotationScanner(SocketIOServer socketServer) {
        return new SpringAnnotationScanner(socketServer);
    }

    @Bean
    public WebSocketListener webSocketListener(SocketIOServer socketServer) {
        return new WebSocketListener(socketServer);
    }

    @Bean
    public WebSocketInitialize webSocketInitialize(SocketIOServer socketIOServer) {
        return new WebSocketInitialize(socketIOServer, this.webSocketProperties);
    }

    public WebSocketConfig(WebSocketProperties webSocketProperties) {
        this.webSocketProperties = webSocketProperties;
    }
}

