/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.cbpl.tool.websocket.handler;

import cn.hutool.core.collection.CollUtil;
import com.corundumstudio.socketio.SocketIOClient;
import com.elitesland.cbpl.tool.extra.spring.SpringUtils;
import com.elitesland.cbpl.tool.websocket.handler.domain.OnlineUser;
import com.elitesland.cbpl.tool.websocket.spi.OnlineListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.socket.sockjs.SockJsTransportFailureException;

public class WebSocketSessionManager {
    private static final Logger logger = LoggerFactory.getLogger(WebSocketSessionManager.class);
    private static final ConcurrentHashMap<String, List<OnlineUser>> SESSION_USERS = new ConcurrentHashMap();

    public static void add(SocketIOClient session) {
        UUID sid = session.getSessionId();
        String userId = WebSocketSessionManager.getUserId(session);
        String ip = WebSocketSessionManager.getClientIP(session);
        OnlineUser user = OnlineUser.of(session, ip);
        SESSION_USERS.compute(userId, (uid, users) -> {
            if (CollUtil.isEmpty((Collection)users)) {
                return CollUtil.newArrayList((Object[])new OnlineUser[]{user});
            }
            users.removeIf(row -> row.getSessionId().equals(sid));
            users.add(user);
            return users;
        });
        if (SpringUtils.isPresent(OnlineListener.class)) {
            OnlineListener listener = (OnlineListener)SpringUtils.getBean(OnlineListener.class);
            listener.add(user);
        }
    }

    public static void remove(SocketIOClient session) {
        UUID sid = session.getSessionId();
        String userId = WebSocketSessionManager.getUserId(session);
        String ip = WebSocketSessionManager.getClientIP(session);
        OnlineUser user = OnlineUser.of(session, ip);
        SESSION_USERS.compute(userId, (uid, users) -> {
            if (CollUtil.isEmpty((Collection)users)) {
                return users;
            }
            users.removeIf(row -> row.getSessionId().equals(sid));
            return users;
        });
        if (SpringUtils.isPresent(OnlineListener.class)) {
            OnlineListener listener = (OnlineListener)SpringUtils.getBean(OnlineListener.class);
            listener.remove(user);
        }
    }

    public static String getUserId(SocketIOClient session) {
        if (SpringUtils.isPresent(OnlineListener.class)) {
            OnlineListener listener = (OnlineListener)SpringUtils.getBean(OnlineListener.class);
            return listener.getUserId(session.getHandshakeData());
        }
        return "G_9";
    }

    public static String getUsername(SocketIOClient session) {
        if (SpringUtils.isPresent(OnlineListener.class)) {
            OnlineListener listener = (OnlineListener)SpringUtils.getBean(OnlineListener.class);
            return listener.getUsername(session.getHandshakeData());
        }
        return "GUEST";
    }

    public static String getNickname(SocketIOClient session) {
        if (SpringUtils.isPresent(OnlineListener.class)) {
            OnlineListener listener = (OnlineListener)SpringUtils.getBean(OnlineListener.class);
            return listener.getNickname(session.getHandshakeData());
        }
        return "\u6e38\u5ba2";
    }

    public static String getTenantCode(SocketIOClient session) {
        if (SpringUtils.isPresent(OnlineListener.class)) {
            OnlineListener listener = (OnlineListener)SpringUtils.getBean(OnlineListener.class);
            return listener.getTenantCode(session.getHandshakeData());
        }
        return "-1";
    }

    private static String getClientIP(SocketIOClient session) {
        if (session.getRemoteAddress() == null) {
            return "unknown";
        }
        return session.getHandshakeData().getAddress().getAddress().getHostAddress();
    }

    public static List<String> push(Set<String> recipients, Consumer<SocketIOClient> consumer) {
        ArrayList<String> recipientsPushed = new ArrayList<String>();
        SESSION_USERS.forEach((uid, users) -> {
            if (recipients.contains(uid)) {
                for (OnlineUser user : users) {
                    if (!user.getSession().isChannelOpen()) continue;
                    try {
                        consumer.accept(user.getSession());
                    }
                    catch (SockJsTransportFailureException e) {
                        logger.error("[PHOENIX-WS] {}-pushToClient failed.", (Object)user.getSessionId());
                    }
                }
                recipientsPushed.add((String)uid);
            }
        });
        return recipientsPushed;
    }

    public static List<OnlineUser> getOnlineUsers() {
        return SESSION_USERS.values().stream().flatMap(Collection::stream).collect(Collectors.toList());
    }
}

