/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.cbpl.tool.websocket.handler.domain;

import com.corundumstudio.socketio.SocketIOClient;
import com.elitesland.cbpl.tool.websocket.handler.WebSocketSessionManager;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.time.LocalDateTime;
import java.util.UUID;

public class OnlineUser {
    @JsonIgnore
    private SocketIOClient session;
    private String ip;
    private LocalDateTime now;

    @JsonProperty
    public UUID getSessionId() {
        return this.session.getSessionId();
    }

    @JsonProperty
    public String getUid() {
        return WebSocketSessionManager.getUserId(this.session);
    }

    @JsonProperty
    public String getUsername() {
        return WebSocketSessionManager.getUsername(this.session);
    }

    @JsonProperty
    public String getNickname() {
        return WebSocketSessionManager.getNickname(this.session);
    }

    @JsonProperty
    public String getTenantCode() {
        return WebSocketSessionManager.getTenantCode(this.session);
    }

    public static OnlineUser of(SocketIOClient session, String ip) {
        OnlineUser user = new OnlineUser();
        user.setSession(session);
        user.setIp(ip);
        user.setNow(LocalDateTime.now());
        return user;
    }

    public SocketIOClient getSession() {
        return this.session;
    }

    public String getIp() {
        return this.ip;
    }

    public LocalDateTime getNow() {
        return this.now;
    }

    @JsonIgnore
    public void setSession(SocketIOClient session) {
        this.session = session;
    }

    public void setIp(String ip) {
        this.ip = ip;
    }

    public void setNow(LocalDateTime now) {
        this.now = now;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof OnlineUser)) {
            return false;
        }
        OnlineUser other = (OnlineUser)o;
        if (!other.canEqual(this)) {
            return false;
        }
        SocketIOClient this$session = this.getSession();
        SocketIOClient other$session = other.getSession();
        if (this$session == null ? other$session != null : !this$session.equals(other$session)) {
            return false;
        }
        String this$ip = this.getIp();
        String other$ip = other.getIp();
        if (this$ip == null ? other$ip != null : !this$ip.equals(other$ip)) {
            return false;
        }
        LocalDateTime this$now = this.getNow();
        LocalDateTime other$now = other.getNow();
        return !(this$now == null ? other$now != null : !((Object)this$now).equals(other$now));
    }

    protected boolean canEqual(Object other) {
        return other instanceof OnlineUser;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        SocketIOClient $session = this.getSession();
        result = result * 59 + ($session == null ? 43 : $session.hashCode());
        String $ip = this.getIp();
        result = result * 59 + ($ip == null ? 43 : $ip.hashCode());
        LocalDateTime $now = this.getNow();
        result = result * 59 + ($now == null ? 43 : ((Object)$now).hashCode());
        return result;
    }

    public String toString() {
        return "OnlineUser(session=" + this.getSession() + ", ip=" + this.getIp() + ", now=" + this.getNow() + ")";
    }
}

