/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.cbpl.tool.core.http;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import javax.servlet.ReadListener;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StreamUtils;

public class RequestWrapper
extends HttpServletRequestWrapper {
    private static final Logger logger = LoggerFactory.getLogger(RequestWrapper.class);
    private final byte[] body;

    public RequestWrapper(HttpServletRequest request) {
        super(request);
        String bodyString = this.getBodyString(request);
        this.body = bodyString.getBytes(StandardCharsets.UTF_8);
    }

    public ServletInputStream getInputStream() {
        final ByteArrayInputStream ins = new ByteArrayInputStream(this.body);
        return new ServletInputStream(){

            public int read() {
                return ins.read();
            }

            public boolean isFinished() {
                return false;
            }

            public boolean isReady() {
                return false;
            }

            public void setReadListener(ReadListener readListener) {
            }
        };
    }

    public String getBodyString() {
        byte[] bodyBytes = StreamUtils.copyToByteArray((InputStream)this.getInputStream());
        return new String(bodyBytes, this.getRequest().getCharacterEncoding());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getBodyString(HttpServletRequest request) {
        StringBuilder sb = new StringBuilder();
        ServletInputStream inputStream = null;
        BufferedReader reader = null;
        try {
            int len;
            inputStream = request.getInputStream();
            reader = new BufferedReader(new InputStreamReader((InputStream)inputStream, StandardCharsets.UTF_8));
            char[] bodyCharBuffer = new char[1024];
            while ((len = reader.read(bodyCharBuffer)) != -1) {
                sb.append(new String(bodyCharBuffer, 0, len));
            }
        }
        catch (IOException e) {
            logger.warn("[PHOENIX-HTTP] RequestWrapper Stream is closed.");
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return sb.toString();
    }
}

