package com.elitesland.cbpl.tool.es.util;

import cn.hutool.core.text.StrPool;
import cn.hutool.core.util.StrUtil;
import com.elitesland.cbpl.tool.core.date.DateUtils;

/**
 * @author eric.hao
 * @since 2023/06/13
 */
public class ElasticsearchUtil {

    private static final String TENANT_SHORT_PREFIX = "_tenant_";

    /**
     * 生成索引名称
     *
     * @param indexName 索引前缀
     * @return 前缀_年.月.日
     */
    public static String indexNameByDay(String indexName) {
        return indexName + StrPool.C_UNDERLINE + DateUtils.todayDot();
    }

    /**
     * 根据类名，生成索引名称
     *
     * @param clazz    存储对象
     * @return 类名_年.月.日
     */
    public static String indexNameByClz(Class<?> clazz) {
        return indexNameByDay(StrUtil.toUnderlineCase(clazz.getSimpleName()));
    }

    /**
     * 生成索引名称
     *
     * @param indexName 索引前缀
     * @param tenantId  租户ID
     * @return 前缀_tenant_id_年.月.日
     */
    public static String indexNameByDay(String indexName, String tenantId) {
        return indexNameByDay(indexName + TENANT_SHORT_PREFIX + tenantId);
    }

    /**
     * 根据类名，生成索引名称
     *
     * @param clazz    存储对象
     * @param tenantId 租户ID
     * @return 类名_tenant_id_年.月.日
     */
    public static String indexNameByClz(Class<?> clazz, String tenantId) {
        return indexNameByDay(StrUtil.toUnderlineCase(clazz.getSimpleName()), tenantId);
    }
}
