package com.elitesland.cbpl.tool.websocket.config;

import lombok.Data;
import org.springframework.boot.context.properties.ConfigurationProperties;

import static com.elitesland.cbpl.tool.websocket.config.WebSocketProperties.WX_CONFIG_PREFIX;

/**
 * @author eric.hao
 * @since 2022/09/14
 */
@Data
@ConfigurationProperties(prefix = WX_CONFIG_PREFIX)
public class WebSocketProperties {

    public static final String WX_CONFIG_PREFIX = "cbpl.tool.ws";

    /**
     * 是否启用：默认关闭
     */
    private boolean enabled;

    /**
     * WebSocket 接口路径
     * <li>供 WebSocket 或 SockJS客户端 访问的地址</li>
     */
    private String entry = "/webSocket";

    /**
     * WebSocket 许可域名
     * <li>指定端点使用SockJS协议</li>
     * <li>如果是关闭跨域校验，这里可以配置「*」</li>
     */
    private String[] allow;
}
