package com.elitesland.cbpl.tool.websocket.handler;

import lombok.NonNull;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.web.socket.CloseStatus;
import org.springframework.web.socket.TextMessage;
import org.springframework.web.socket.WebSocketSession;
import org.springframework.web.socket.handler.TextWebSocketHandler;

/**
 * @author eric.hao
 * @since 2024/11/18
 */
@Slf4j
@RequiredArgsConstructor
public class WebSocketAuthHandler extends TextWebSocketHandler {

    /**
     * Socket 建立连接成功
     */
    @Override
    public void afterConnectionEstablished(WebSocketSession session) throws Exception {
        logger.info("[PHOENIX-WS] websocket connection established: {} of u-{}", session.getId(), WsSessionManager.getUserId(session));
        WsSessionManager.add(session);
    }

    /**
     * 接收客户端传来消息事件
     */
    @Override
    protected void handleTextMessage(@NonNull WebSocketSession session, @NonNull TextMessage message) throws Exception {
        // 目前WebSocket的使用场景仅用于单向发送站内消息，故消息接收处理被忽略。
        logger.trace("[PHOENIX-WS] message from websocket client: {}", message);
    }

    /**
     * Socket 断开连接时
     */
    @Override
    public void afterConnectionClosed(WebSocketSession session, @NonNull CloseStatus status) throws Exception {
        logger.info("[PHOENIX-WS] afterConnectionClosed u-{}", WsSessionManager.getUserId(session));
        WsSessionManager.removeAndClose(session);
        logger.info("[PHOENIX-WS] websocket connection closed: {}", session.getId());
    }
}
