package com.elitesland.cbpl.tool.websocket.interceptor;

import cn.hutool.core.util.CharsetUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.http.HttpUtil;
import com.elitesland.cbpl.tool.core.http.HttpServletUtil;
import com.elitesland.cbpl.tool.websocket.constant.WebSocketInstant;
import lombok.NonNull;
import org.springframework.http.server.ServerHttpRequest;
import org.springframework.http.server.ServerHttpResponse;
import org.springframework.web.socket.WebSocketHandler;
import org.springframework.web.socket.server.HandshakeInterceptor;

import java.util.Map;

/**
 * WebSocket 握手请求拦截器<br/>
 * 写入 userId、ip 等信息
 *
 * @author eric.hao
 * @since 2024/11/18
 */
public class CustomWebSocketInterceptor implements HandshakeInterceptor {


    @Override
    public boolean beforeHandshake(ServerHttpRequest request, @NonNull ServerHttpResponse response,
                                   @NonNull WebSocketHandler wsHandler, @NonNull Map<String, Object> attributes) throws Exception {
        // 获得请求参数
        Map<String, String> paramMap = HttpUtil.decodeParamMap(request.getURI().getQuery(), CharsetUtil.CHARSET_UTF_8);
        String uid = paramMap.get(WebSocketInstant.URI_PARAM_USER_ID);
        if (StrUtil.isNotBlank(uid)) {
            attributes.put(WebSocketInstant.URI_PARAM_USER_ID, uid);
            attributes.put(WebSocketInstant.URI_PARAM_IP, HttpServletUtil.currentClientIp());
            return true;
        }
        return false;
    }

    @Override
    public void afterHandshake(@NonNull ServerHttpRequest request, @NonNull ServerHttpResponse response,
                               @NonNull WebSocketHandler wsHandler, Exception exception) {
    }
}
