package com.elitesland.cbpl.tool.websocket.notifier;

import com.elitesland.cbpl.tool.core.bean.BeanUtils;
import com.elitesland.cbpl.tool.websocket.handler.WsSessionManager;
import com.elitesland.cbpl.tool.websocket.notifier.domain.NotifierPayload;
import lombok.RequiredArgsConstructor;
import lombok.SneakyThrows;
import lombok.extern.slf4j.Slf4j;
import org.springframework.web.socket.TextMessage;
import org.springframework.web.socket.WebSocketSession;

import java.util.Optional;

/**
 * 站内消息推送者(通过WebSocket推送至前端)
 *
 * @author eric.hao
 * @since 2022/09/14
 */
@Slf4j
@RequiredArgsConstructor
public class WebSocketNotifier {

    public <T extends NotifierPayload> void notify(T payload) {
        Optional<String> jsonOptional = BeanUtils.toJsonOptional(payload);
        if (jsonOptional.isEmpty()) {
            logger.warn("[PHOENIX-WS] error payload: {}", payload);
            return;
        }
        var recipients = payload.getTos();
        if (recipients != null && !recipients.isEmpty()) {
            logger.warn("[PHOENIX-WS] recipients is empty.");
            return;
        }
        var message = new TextMessage(jsonOptional.get());
        var recipientsPushed = WsSessionManager.push(recipients, (session) -> pushToClient(session, message));
        logger.debug("[PHOENIX-WS] recipients has been pushed: {}", recipientsPushed);
    }

    @SneakyThrows
    private void pushToClient(WebSocketSession session, TextMessage message) {
        session.sendMessage(message);
    }
}
