package com.elitesland.cbpl.tool.websocket.notifier.domain;

import com.fasterxml.jackson.annotation.JsonIgnore;

import java.util.Set;

/**
 * 站内消息内容
 *
 * @author eric.hao
 * @since 2022/09/15
 */
public interface NotifierPayload {

    /**
     * @return 消息主题
     */
    String getSubject();

    /**
     * @return 详细内容
     */
    Object getContent();

    /**
     * @return 发信方
     */
    String getFrom();

    /**
     * @return 收信方
     */
    Set<String> getTos();

    /**
     * @return 收信方(第一个)
     */
    @JsonIgnore
    default String getTo() {
        return getTos().stream().findFirst().orElseThrow(() ->
            new IllegalStateException("[PHOENIX-WS] No recipient in this message."));
    }

}
